/*
 * Decompiled with CFR 0.152.
 */
package panther.program;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import org.w3c.dom.Node;
import panther.util.general.XMLUtils;
import pse.assessment.PantherForm;
import pse.assessment.PantherTask;
import pse.core.PantherEngine;
import pse.pt.PacketTracer;
import pse.result.AutoSave;
import pse.result.Result;
import pse.result.ResultObject;
import pse.result.Session;
import pse.result.SessionEnd;
import pse.result.SessionStart;
import pse.result.SittingEnd;
import pse.result.SittingStart;
import pse.result.XpassSession;
import pse.util.general.FileUtils;
import pse.util.general.XmlWriter;

public abstract class AbstractScore {
    protected PantherForm createDefaultForm(PantherTask pantherTask) {
        return PantherForm.createDefaultForm(pantherTask);
    }

    protected Session createDefaultSession(PantherForm pantherForm, PantherTask pantherTask, PacketTracer packetTracer) throws Exception {
        Calendar calendar = Calendar.getInstance();
        Session session = new Session();
        SessionStart sessionStart = new SessionStart();
        sessionStart.setClientTime(calendar);
        sessionStart.setTimeRemaining(3600000L);
        sessionStart.setTimeUsed(1800000L);
        sessionStart.setTimeRemaining(1800000L);
        session.addEvent(sessionStart);
        SittingStart sittingStart = new SittingStart();
        sittingStart.setClientTime(calendar);
        sittingStart.setTimeRemaining(3600000L);
        sittingStart.setTimeUsed(1800000L);
        sittingStart.setTimeRemaining(1800000L);
        sittingStart.setBrowserName("Firefox");
        sittingStart.setBrowserVersion("3.0");
        sittingStart.setOsName("Windows Vista");
        sittingStart.setOsVersion("Basic");
        sittingStart.setPtHome("C:\\Program Files\\Packet Tracer 5.3.1");
        sittingStart.setPtVersion("5.3.1");
        XpassSession xpassSession = new XpassSession();
        xpassSession.setScenarioFormGuid(pantherTask.getPantherIdent());
        xpassSession.setVdsAssessmentGuid(pantherForm.getAssessment().getVdsIdent());
        xpassSession.setVdsErId("1234567890");
        xpassSession.setVdsFormGuid(pantherForm.getVdsIdent());
        xpassSession.setVdsTaskGuid(pantherTask.getVdsIdent());
        xpassSession.setVdsUserId("123456");
        xpassSession.setTimeLimit(3600000L);
        xpassSession.setTimeUsed(3600000L);
        sittingStart.setXpassSession(xpassSession);
        session.addEvent(sittingStart);
        AutoSave autoSave = new AutoSave();
        autoSave.setClientTime(calendar);
        autoSave.setTimeRemaining(3600000L);
        autoSave.setTimeUsed(1800000L);
        autoSave.setTimeRemaining(1800000L);
        session.addEvent(autoSave);
        SittingEnd sittingEnd = new SittingEnd();
        sittingEnd.setClientTime(calendar);
        sittingEnd.setTimeRemaining(3600000L);
        sittingEnd.setTimeUsed(1800000L);
        sittingEnd.setTimeRemaining(1800000L);
        session.addEvent(sittingEnd);
        SessionEnd sessionEnd = new SessionEnd();
        sessionEnd.setClientTime(calendar);
        sessionEnd.setTimeRemaining(3600000L);
        sessionEnd.setTimeUsed(1800000L);
        sessionEnd.setTimeRemaining(1800000L);
        session.addEvent(sessionEnd);
        return session;
    }

    protected Result createResult(File file, PantherEngine pantherEngine, int n, PantherTask pantherTask, PantherForm pantherForm) throws Exception {
        PacketTracer packetTracer = new PacketTracer("localhost", n, true);
        packetTracer.connect();
        Session session = this.createDefaultSession(pantherForm, pantherTask, packetTracer);
        Result result = pantherEngine.extractResult(session, packetTracer);
        this.write(file, result);
        return result;
    }

    protected Result createScores(File file, PantherEngine pantherEngine, Result result, PantherTask pantherTask, PantherForm pantherForm) throws Exception {
        Result result2 = pantherEngine.score(result, pantherTask, pantherForm);
        this.writeFile(file, result2.toXmlString());
        return result2;
    }

    protected Session createSimpleDefaultSession(PacketTracer packetTracer) throws Exception {
        Calendar calendar = Calendar.getInstance();
        Session session = new Session();
        SessionStart sessionStart = new SessionStart();
        sessionStart.setClientTime(calendar);
        sessionStart.setServerTime(calendar);
        sessionStart.setTimeRemaining(3600000L);
        sessionStart.setTimeUsed(1800000L);
        sessionStart.setTimeRemaining(1800000L);
        session.addEvent(sessionStart);
        SessionEnd sessionEnd = new SessionEnd();
        sessionEnd.setClientTime(calendar);
        sessionEnd.setServerTime(calendar);
        sessionEnd.setTimeRemaining(3600000L);
        sessionEnd.setTimeUsed(1800000L);
        sessionEnd.setTimeRemaining(1800000L);
        session.addEvent(sessionEnd);
        return session;
    }

    protected String generateIip(File file, PantherEngine pantherEngine, Result result, PantherTask pantherTask, PantherForm pantherForm) throws Exception {
        String string = pantherEngine.generateIip(result, pantherTask, pantherForm);
        this.writeFile(file, string);
        return string;
    }

    protected PantherEngine instantiateEngine() {
        return new PantherEngine();
    }

    protected int launchPt(File file) throws Exception {
        int n = PacketTracer.findOpenIpcPort(39000);
        PacketTracer packetTracer = new PacketTracer("localhost", n, true);
        packetTracer.launch();
        packetTracer.connect();
        packetTracer.fileOpen(file.getCanonicalPath());
        return n;
    }

    protected Result readResult(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        Node node = XMLUtils.parseToNode(fileReader);
        fileReader.close();
        Result result = new Result();
        result.fromParentNode(node);
        return result;
    }

    protected Result readScores(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        Node node = XMLUtils.parseToNode(fileReader);
        fileReader.close();
        Result result = new Result();
        result.fromParentNode(node);
        return result;
    }

    protected Session readSession(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        Node node = XMLUtils.parseToNode(fileReader);
        fileReader.close();
        Session session = new Session();
        session.fromParentNode(node);
        return session;
    }

    protected PantherTask readTask(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        Node node = XMLUtils.parseToNode(fileReader);
        fileReader.close();
        PantherTask pantherTask = new PantherTask();
        pantherTask.fromParentNode(node);
        return pantherTask;
    }

    protected void write(File file, ResultObject resultObject) throws Exception {
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        XmlWriter xmlWriter = new XmlWriter(printWriter, "", "  ");
        resultObject.addXmlDeclarations(xmlWriter);
        resultObject.toXmlString(xmlWriter);
        printWriter.close();
    }

    protected void writeFile(File file, String string) throws Exception {
        FileUtils.writeFile(file, string);
    }

    protected void writeResult(File file, Result result) throws Exception {
        this.write(file, result);
    }
}

